require( "quest/m1_spendalot2/convout.lua" );
combine_speech_tables();

flo_anim_table =
{
	"anim/flo/stands", "anim/flo/standse", "anim/flo/talksegestures",
	"anim/flo/talks",
	"anim/flo/talkse",
	"anim/flo/walke",
	"anim/flo/walkn",
	"anim/flo/walkne",
	"anim/flo/walks",
	"anim/flo/walkse",
	"anim/flo/catchsnookums",
};

local gatorAnimPos = { x = 1200, y = 0 };
local snookumsGatorPos = { x = gatorAnimPos.x + 260, y = gatorAnimPos.y + 350 };

flo_spec =
{
	name = "FLO";
	halo = "quest/objects/flo";
	anim = flo_anim_table;
	cantuse = "obj_flo_cantuse";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:AddFlag(AFLAG.AFLAG_NO_GROUND_CLICKS);
		actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);	-- enable ground-based scaling
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(flo_speed);
		
		if game:GetLastScene() == "m1_intersection" then
			actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
			actor:JumpToNamedPoint("intersection");
			actor:FaceNow(DIR.E);
			scene:SetCameraFollowActor(actor);
			actor:WalkTo("spendalot2west");
			
			scene.CAMERA:JumpToNamedPoint("spendalot2west");
		else -- bobbies
			scene.DOOR:PlayAnim("Opened");
			actor:Face(DIR.S);
			actor:JumpToNamedPoint("to_bobbis");
			actor:WalkTo("spendalot2west");
			delay(3);
			scene.DOOR:PlayAnim("Close");
			wait_walkto();
			actor:Face(DIR.S);
			
			if game:Get("just_completed_snookums") == 1 then
				sfx:SetMusic("audio/music/music_delivery_movies.ogg", true);
				scene:DisplayFlash("flash/delivery_dog_intro.swf");
				wait_subscene();
				sfx:SetMusic("audio/music/walkingmusic.ogg", true);
				game:Set("just_completed_snookums", 2);
				
				if quest_complete("wedding_dress") then
					if flo_after_napkin_prompt(actor) == false then
						run_super_conversation(actor, "conv_goto_module2_B");
					end
				end
			end
		end
		
		game:SetString("map_position", "m1_petspa");
		
		if game:Get("first_time_m1_spendalot2") < 1 then
			game:Set("first_time_m1_spendalot2", 1);
		end
		
		wait_walkto();
		actor:Face(DIR.S);
		scene:SetCameraFollowActor(scene.CAMERA);
		actor:ClearFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		
		spawn_nav_arrow(door_bobbies_spec);
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
	
	on_arrive = function(flo1, flo2)
		if (game:Get("talked_to_derek") > 0 or game:Get("asked_derek_for_oil") > 0) and game:Get("got_cofee_cup_from_diner") < 1 then
			convproc("FLO", "quip_flo_spendalot2_A");
		else
			convproc("FLO", "quip_flo_general");
		end
	end;
	
	on_use_inv = function(item, flo, flo2)
		flo_inv_generic(flo, item);
		return RESPONSE.INV_HANDLED;
	end;
};

derek_anim_table =
{
	"anim/derek/talk",
	"anim/derek/coffee",
};

function derek_conv(flo)
	flo:SetMode(MODE.CUTSCENE);
	
	if game:Get("given_derek_coffee") < 1 then
		if game:Get("talked_to_derek") < 1 then
			run_super_conversation(flo, "conv_derek_intro");
		else
			run_super_conversation(flo, "conv_derek_tired");
		end
	else
		run_super_conversation(flo, "conv_derek_awake");
	end
	
	game:Set("talked_to_derek", 1);
	
	scene.FLO:WalkTo("spendalot2west");
	wait_walkto();
	flo:Face(DIR.S);
	
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function give_derek_coffeecup(flo)
	flo:SetMode(MODE.CUTSCENE);
	BAG_INV:RemoveInventory("coffeecup");	
	run_super_conversation(flo, "conv_give_coffee_A");
	game:Set("given_derek_coffee", 1);
	game:Set("talked_to_derek", 1);
	complete_quest("give_derek_coffee");
	
	scene.FLO:WalkTo("spendalot2west");
	wait_walkto();
	flo:Face(DIR.S);
		
	flo:SetMode(MODE.FOLLOWCLICKS);
end

derek_spec = 
{
	name = "DEREK";
	halo = "quest/objects/derekw";
	anim = derek_anim_table;
	
	command = function(actor)
		prepare_actor_text(actor, derek_text_spec);
		--actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(derek_speed);
		actor:JumpToNamedPoint("derek");
		actor:FaceNow(DIR.W);
		
		if game:Get("given_derek_coffee") < 1 then
			actor:LastingEmotion();
			actor:SetEmotion("sad");
		end;
	end;
	
	on_arrive=  function(flo, derek)
		flo:FaceActor(derek);
		flo:StartProc(derek_conv);
	end;
	
	on_use_inv = function(item, flo, derek)
		flo:FaceActor(derek);
		if item == "coffeecup" then
			flo:StartProc(give_derek_coffeecup);
			return RESPONSE.INV_HANDLED;
		else
			return RESPONSE.INV_UNHANDLED;
		end
	end;
};

local snookums_point = 0;
local snookums_points_num = 4;

function catch_snookums(flo)
	flo:SetMode(MODE.CUTSCENE);
	--if game:Get("seen_snookums") < 1 then
	--	add_quest("lure_snookums");
	--end
	game:Set("seen_snookums", 1);
	
	if game:Get("first_time_pet_spa") < 1 then
		run_super_conversation(flo, "quip_snookums");
	else
		local rand = math.random(1, snookums_points_num);
		
		if rand == snookums_point then
			snookums_point = snookums_point + 1;
			if snookums_point > snookums_points_num then
				snookums_point = 1;
			end
		else
			snookums_point = rand;
		end
		
		scene.SNOOKUMS:WalkTo("snookums" .. snookums_point);
--		wait_walkto(scene.SNOOKUMS);
		--scene.SNOOKUMS:JumpToNamedPoint("snookums" .. snookums_point);
		sfx:PlaySFX("audio/sfx/poodle_run.ogg");
		local clicked_on_snookums = game:Get("clicked_on_snookums_count");
				
		if clicked_on_snookums < 1 then
			clicked_on_snookums = 1;
		else
			clicked_on_snookums = clicked_on_snookums + 1;
		end
		
		if clicked_on_snookums > 3 then
			local randABC = math.random(1, 3);
			
			if randABC == 1 then
				run_super_conversation(flo, "quip_snookums_give_up_A");
			elseif randABC == 2 then
				run_super_conversation(flo, "quip_snookums_give_up_B");
			else
				run_super_conversation(flo, "quip_snookums_give_up_C");
			end
			
			if not quest_added("lure_snookums") then
				add_quest("lure_snookums");
			end
			
			clicked_on_snookums = 0;
		else
			run_super_conversation(flo, "quip_snookums_catch_" .. rand);
		end
		
		game:Set("clicked_on_snookums_count", clicked_on_snookums);
	end
	
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function give_snookums_dogtreat(flo)
	flo:SetMode(MODE.CUTSCENE);
	
	if game:Get("first_time_pet_spa") < 1 then
		run_super_conversation(flo, "quip_snookums_try_treat");
	else
		game:Set("seen_snookums", 1);
		BAG_INV:RemoveInventory("dogtreat");
		--run_super_conversation(flo, "quip_snookums_treat");
		
		scene.GATOR:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		scene.GATOR:PlayAnim("BonePlaced");
		
		local floWalkPos = { x = gatorAnimPos.x + 306, y = gatorAnimPos.y + 402 };
		scene.FLO:WalkToXY(floWalkPos);
		wait_walkto(scene.FLO);
		
		scene.FLO:Face(DIR.SE);
		delay(30);
		
		run_super_conversation(flo, "quip_snookums_treat_A");
		
		scene.SNOOKUMS:WalkToXY(snookumsGatorPos);
		wait_walkto(scene.SNOOKUMS);
		scene.SNOOKUMS:Face(DIR.E);
		
		scene.BENCH:SetDepthValue(100);
		
		delay(60);
		
		local floPos = scene.FLO:GetPosition();
		scene.FLO:JumpToPoint(gatorAnimPos);
		scene.FLO:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		scene.FLO:ClearFlag(AFLAG.AFLAG_SCALE_BY_Y);
		scene.FLO:SetDepthMode(DEPTH.DEPTH_FIXED);
		scene.FLO:SetDepthValue(250);
		scene.FLO:PlayAnim("CatchSnookums");

		scene.GATOR:PlayAnim("BoneAndGator");
		
		scene.SNOOKUMS:SetDepthValue(200);
		scene.SNOOKUMS:SetScale(1);
		
		scene.SNOOKUMS:JumpToPoint(gatorAnimPos);
		scene.SNOOKUMS:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		scene.SNOOKUMS:ClearFlag(AFLAG.AFLAG_SCALE_BY_Y);
		scene.SNOOKUMS:PlayAnim("Gator");
		
		sfx:PlaySFX("audio/sfx/poodle_treat.ogg");
		
		delay(60);
		scene.SNOOKUMS:SetDepthMode(DEPTH.DEPTH_FIXED);
		scene.SNOOKUMS:SetDepthValue(300);
		
		wait_anim(scene.SNOOKUMS);
		
		scene.SNOOKUMS:Expire();
		scene.FLO:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);
		scene.FLO:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		scene.FLO:SetDepthMode(DEPTH.DEPTH_BY_Y);
		scene.FLO:JumpToPoint(floPos);
		
		scene.FLO:PlayAnim("DoStandSE");
		addInventory(inv_desc_snookums);
		
		run_super_conversation(flo, "quip_snookums_treat_B");
		
		spawn_activity_complete_text("text_got_snookums", "audio/sfx/complete_display.ogg");
		coroutine.yield(RESUME.ON_SIGNAL);
		
		scene.FLO:WalkTo("spendalot2east");
		wait_walkto(scene.FLO);
		scene.FLO:PlayAnim("DoStandS");
		
		game:Set("got_snookums", 1);
		add_quest("give_walter_snookums", false);
		complete_quest("lure_snookums");
	end
	flo:SetMode(MODE.FOLLOWCLICKS);
end

snookums_anim_table =
{
	"anim/snookums/stand",
	"anim/snookums/gator",
	"anim/snookums/rund",
	"anim/snookums/runh"
};

snookums_spec = 
{
	name = "SNOOKUMS";
	halo = "quest/objects/snookums";
	anim = snookums_anim_table;
	
	command = function(actor)
		prepare_actor_text(actor, snookums_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		--actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetDepthValue(100);
		actor:SetWalkSpeed(snookums_speed);
		actor:JumpToNamedPoint("snookums1");
		actor:SetScale(1.25);
		snookums_point = 1;
		actor:FaceNow(DIR.W);
	end;
	
	on_arrive=  function(flo, snookums)
		flo:FaceActor(snookums);
		flo:StartProc(catch_snookums);
	end;
	
	on_use_inv = function(item, flo, snookums)
		flo:FaceActor(snookums);
		if item == "dogtreat" then
			-- note this is really supposed to be given to a sewer grate, then
			-- an aligator is supposed to pop up and snookums jumps into flo's arms
			flo:StartProc(give_snookums_dogtreat);
			return RESPONSE.INV_HANDLED;
		else
			return RESPONSE.INV_UNHANDLED;
		end
	end;
};

gator_spec = 
{
	name = "GATOR";
	gfx = { anim = "anim/m1_spendalot2/bone_and_gator" };
	
	command = function(actor)
		actor:JumpToPoint(gatorAnimPos);
		actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		actor:SetDepthValue(400);
		
		if game:Get("got_snookums") == 1 then
			actor:PlayAnim("ManholeOpen");
		else
			actor:PlayAnim("ManholeClosed");
		end
	end
}

function gotointersection(flo)
	flo:SetMode(MODE.CUTSCENE);
	scene.DOOR_BOBBIES:Expire();
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	scene:SetCameraFollowActor(scene.FLO);
	flo:WalkTo("to_intersection");
	delay(150);
	goto_scene(flo, "m1_intersection", true);
end

to_intersection_spec = 
{
	name = "TO_INTERSECTION";
	halo = "to_intersection";
	cursor = "cursor_arrow_w";
	goto_fn = gotointersection;
}

function gotobobbies(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("module_progress") < 3 then
		scene.DOOR_BOBBIES:SetMode(MODE.CUTSCENE);
		flo:WalkTo("to_bobbis");
		--wait_walkto();
		
		goto_scene(flo, "m1_petspa");
	else
		run_super_conversation(flo, "quip_shop_closed");
		flo:SetMode(MODE.FOLLOWCLICKS);
	end
end

door_bobbies_spec =
{
	name = "DOOR_BOBBIES";
	halo = "door_bobbis";
	
	cursor = "cursor_arrow_n";
	goto_fn = gotobobbies;
	point_at_fn = function(actor, enter)
		if actor:GetMode() ~= MODE.CUTSCENE and game:Get("module_progress") < 3 then
			if enter then
				scene.DOOR:PlayAnim("Open");
			else
				scene.DOOR:PlayAnim("Close");
			end
		end
	end;
}

door_spec =
{
	name = "DOOR";
	gfx = {anim = "anim/m1_spendalot2/door"};
	
	command = function(actor)
		actor:PlayAnim("Closed");
		actor:SetDepthValue("1");
	end;
}

function gotospendalot2east(flo)
	flo:SetMode(MODE.CUTSCENE);
	scene.DOOR_BOBBIES:Expire();
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	scene:SetCameraFollowActor(scene.FLO);
	
	flo:WalkTo("spendalot2east");
	wait_walkto();
	flo:Face(DIR.S);
	
	scene.CAMERA:JumpToNamedPoint("spendalot2east");
	scene:SetCameraFollowActor(scene.CAMERA);
	flo:ClearFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	flo:SetMode(MODE.FOLLOWCLICKS);
	game:Set("been_to_park", 1);
	game:SetString("map_position", "m1_park");
end

to_spendalot2east_spec = 
{
	name = "TO_SPENDALOT2EAST";
	halo = "to_spendaloteast";
	cursor = "cursor_arrow_e";
	goto_fn = gotospendalot2east;
}

function gotospendalot2west(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	scene:SetCameraFollowActor(scene.FLO);
	
	flo:WalkTo("spendalot2west");
	wait_walkto();
	flo:Face(DIR.S);
	
	scene.CAMERA:JumpToNamedPoint("spendalot2west");
	scene:SetCameraFollowActor(scene.CAMERA);
	flo:ClearFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	spawn_nav_arrow(door_bobbies_spec);
	flo:SetMode(MODE.FOLLOWCLICKS);
	game:SetString("map_position", "m1_petspa");
end

to_spendalot2west_spec = 
{
	name = "TO_SPENDALOT2WEST";
	halo = "to_spendalotwest";
	cursor = "cursor_arrow_w";
	goto_fn = gotospendalot2west;
}

function clickoilcan(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("given_derek_coffee") < 1 then
		if game:Get("asked_derek_for_oil") < 1 then
			run_super_conversation(flo, "conv_oil_A");
			add_quest("give_derek_coffee");
			game:Set("asked_derek_for_oil", 1);
		else
			run_super_conversation(flo, "conv_oil_B");
		end
	else
		run_super_conversation(flo, "conv_take_oil");
		scene.OILCAN:Expire();
		addInventory(inv_desc_oil);
		game:Set("got_oil_can", 1);
		add_quest("give_diane_oil");
	end
	flo:Face(DIR.S);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

oilcan_spec = 
{
	name = "OILCAN";
	halo = "oilcan";
	gfx = { image = "oilcan" };
	
	command = function(actor)
	end;
	
	on_arrive = function(flo, oilcan)
		flo:FaceActor(scene.DEREK);
		flo:StartProc(clickoilcan);
	end;
	
	point_at_fn = function(actor, enter)
	end;
}

pet_spa_sign_spec = 
{
	name = "PET_SPA_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/itc_benguiat_gothic_std_hvy.mvec",
			color = { a = 1, r = 0.71, g = 0.2, b = 0.6 },
			--outline_size = 1,
			--outline_color = { a = 1, r = 0.5, g = 0.25, b = 0 },
			lineheight = 55,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_pet_spa_sign");
		actor:StopWalking();
		actor:SetPolygon({x=640,y=128}, {x=760,y=128}, {x=640,y=177}, {x=760,y=177});
		actor:TextToImage(5, 10);
	end;
}

fountain_spec =
{
	name = "FOUNTAIN";
	gfx = {anim = "anim/m1_spendalot2/ambient"};
	
	command = function(actor)
		actor:PlayAnim("DoAnim");
		actor:SetDepthValue("1");
	end;
}

hydrant_spec =
{
	name = "HYDRANT";
	gfx = {anim = "anim/m1_spendalot2/hydrant"};
	
	command = function(actor)
		actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		actor:PlayAnim("Drip");
		actor:SetDepthValue("1");
	end;
}

camera_spec = 
{
	name = "CAMERA";
	command = function(actor)

		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:SetWalkSpeed(6);
		
		if game:GetLastScene() == "m1_intersection" then
			actor:JumpToNamedPoint("intersection");
		else -- dress shop
			actor:JumpToNamedPoint("spendalot2west");
		end
	end;
};

bench_spec = 
{
	name = "BENCH";
	gfx = { image = "bench" };
	
	command = function(actor)
		actor:SetDepthValue(365);
	end;
};

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/walkingmusic.ogg", true);
		sfx:PlaySFX("audio/sfx/ambient_mod1.ogg", true);
		scene:SetRoomScale(300, 550, 0.7, 0.8);	--topline, bottomline, topscale, bottomscale
		
		local no_fade = game:GetLastScene() == "m1_intersection";
		fade_scene_up(false, no_fade);
		
		if IsCheatMode() then
			-- testing data
			--BAG_INV:AddInventory(inv_desc_coffeecup);
			--game:Set("got_cofee_cup_from_diner", 1);
			--BAG_INV:AddInventory(inv_desc_dogtreat);
			--BAG_INV:AddInventory(inv_desc_snookums);
			--game:Set("first_time_pet_spa", 1);
		end
		
		spawn_nav_arrow(to_intersection_spec);
		spawn_nav_arrow(to_spendalot2east_spec);
		spawn_nav_arrow(to_spendalot2west_spec);
		
		scene:SetCameraFollowActor(scene.CAMERA);		-- Attach the camera to follow "CAMERA" actor
		scene:SetCameraMargin { x = 400, y = 300 };
		
		if game:Get("got_oil_can") < 1 then
			scene:Spawn(oilcan_spec);
		end;
		
		if game:Get("got_snookums") < 1 then
			scene:Spawn(snookums_spec);
		end
		
		if game:Get("module_progress") < 3 then
			scene:Spawn(derek_spec);
			spawn_simple_hotspot("derek_car");
		end
		
		spawn_simple_hotspot("end_of_street", 5);
	end;
};

bird_spec = 
{
	name = "BIRD_SPEC";
	gfx = { anim = "anim/m1_spendalot1/bird" };
	halo = "quest/m1_spendalot1/bird";
	
	command = function(actor)
		actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		actor:SetDepthValue(601);
		actor.animating = false;
		actor:PlayAnim("Rest");
		actor:SetScaleX(-1);
		actor:JumpToPoint { x = 2400, y = 0 };
	end;
	
	on_arrive = function(flo, actor)
		convproc("FLO", "backup_quip_street_bird");
		if actor.animating == false then
			actor:StartProc(function(actor)
				actor:DumpZone();
				actor:PlayAnim("Idle");
				actor.animating = true;
				wait_anim();
				actor.animating = false;
				actor:LoadZone("quest/m1_spendalot1/bird");
			end);
		end
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces", -- load pieces
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		{ "tree2", 365 },
		{ "tree3", 120 },
		{ "tree4", 365 },
		
		{ "car1", 460 },
		{ "car3", 460 },
		{ "car2", 460 },
		{ "car4", 460 },
		
		{ "lamp1", 420 },
		{ "lamp2", 420 },
		{ "hydrant1", 420 },
		{ "trashcan", 365 },
		{ "waterfountain",420 },

		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		camera_spec,
		scene_setup,
		
		fountain_spec,
		hydrant_spec,
		door_spec,
		gator_spec,
		flo_spec, -- the main actor
		
		pet_spa_sign_spec,
		bench_spec,
		bird_spec,
	};
};
